/***************************************************************************
 *     GModelSpatialRadial.i - Abstract radial spatial model base class    *
 * ----------------------------------------------------------------------- *
 *  copyright (C) 2011-2022 by Juergen Knoedlseder                         *
 * ----------------------------------------------------------------------- *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 *                                                                         *
 ***************************************************************************/
/**
 * @file GModelSpatialRadial.i
 * @brief Abstract radial model base class Python interface
 * @author Juergen Knoedlseder
 */
%{
/* Put headers and other declarations here that are needed for compilation */
#include "GModelSpatialRadial.hpp"
%}


/***********************************************************************//**
 * @class GModelSpatialRadial
 *
 * @brief Abstract radial spatial model base class
 ***************************************************************************/
class GModelSpatialRadial : public GModelSpatial {

public:
    // Constructors and destructors
    GModelSpatialRadial(void);
    GModelSpatialRadial(const GModelSpatialRadial& model);
    explicit GModelSpatialRadial(const GXmlElement& xml);
    virtual ~GModelSpatialRadial(void);

    // Pure virtual methods
    virtual void                 clear(void) = 0;
    virtual GModelSpatialRadial* clone(void) const = 0;
    virtual std::string          classname(void) const = 0;
    virtual double               eval(const double&  theta,
                                      const GEnergy& energy,
                                      const GTime& time,
                                      const bool& gradients = false) const = 0;
    virtual GSkyDir              mc(const GEnergy& energy,
                                    const GTime& time,
                                    GRan& ran) const = 0;
    virtual bool                 contains(const GSkyDir& dir,
                                          const double&  margin = 0.0) const = 0;
    virtual double               theta_max(void) const = 0;

    // Implemented virtual base class methods
    virtual bool   is_energy_dependent(void) const;
    virtual bool   is_time_dependent(void) const;
    virtual double eval(const GPhoton& photon,
                        const bool&    gradients = false) const;
    virtual double mc_norm(const GSkyDir& dir, const double&  radius) const;
    virtual void   read(const GXmlElement& xml);
    virtual void   write(GXmlElement& xml) const;

    // Other methods
    std::string    coordsys(void) const;
    const GSkyDir& dir(void) const;
    void           dir(const GSkyDir& dir);
};


/***********************************************************************//**
 * @brief GModelSpatialRadial class extension
 ***************************************************************************/
%extend GModelSpatialRadial {
};
