/***************************************************************************
 *       GModelDataMultiplicative.i - Multiplicative data model class      *
 * ----------------------------------------------------------------------- *
 *  copyright (C) 2025 by Juergen Knoedlseder                              *
 * ----------------------------------------------------------------------- *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 *                                                                         *
 ***************************************************************************/
/**
 * @file GModelDataMultiplicative.i
 * @brief Multiplicative data model class interface definition
 * @author Juergen Knoedlseder
 */
%{
/* Put headers and other declarations here that are needed for compilation */
#include "GModelDataMultiplicative.hpp"
%}


/***********************************************************************//**
 * @class GModelDataMultiplicative
 *
 * @brief Multiplicative data model class
 ***************************************************************************/
class GModelDataMultiplicative : public GModelData {

public:
    // Constructors and destructors
    GModelDataMultiplicative(void);
    explicit GModelDataMultiplicative(const GXmlElement& xml);
    GModelDataMultiplicative(const GModelDataMultiplicative& model);
    virtual ~GModelDataMultiplicative(void);

    // Implemented pure virtual methods
    virtual void                      clear(void);
    virtual GModelDataMultiplicative* clone(void) const;
    virtual std::string               classname(void) const;
    virtual std::string               type(void) const;
    virtual bool                      is_constant(void) const;
    virtual double                    eval(const GEvent& event,
                                           const GObservation& obs,
                                           const bool& gradients = false) const;
    virtual double                    npred(const GEnergy& obsEng, const GTime& obsTime,
                                            const GObservation& obs) const;
    virtual GEvents*                  mc(const GObservation& obs, GRan& ran) const;
    virtual void                      read(const GXmlElement& xml);
    virtual void                      write(GXmlElement& xml) const;

    // Implemented pure virtual base class methods
    virtual GVector eval(const GObservation& obs,
                         GMatrixSparse* gradients = NULL,
                         const int& offset = 0) const;

    // Other methods
    void              append(const GModelData& model);
    int               components(void) const;
    const GModelData* component(const int& index) const;
    const GModelData* component(const std::string& name) const;
};


/***********************************************************************//**
 * @brief GModelDataMultiplicative class extension
 ***************************************************************************/
%extend GModelDataMultiplicative {
    GModelDataMultiplicative copy() {
        return (*self);
    }
%pythoncode {
    def __getstate__(self):
        xml = gammalib.GXmlElement()
        self.write(xml)
        state = xml,
        return state
    def __setstate__(self, state):
        self.__init__(state[0].element(0))
}
};
