/***************************************************************************
 *                      GMath.i - Mathematical functions                   *
 * ----------------------------------------------------------------------- *
 *  copyright (C) 2012-2025 by Juergen Knoedlseder                         *
 * ----------------------------------------------------------------------- *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 *                                                                         *
 ***************************************************************************/
/**
 * @file GMath.i
 * @brief Mathematical function definitions
 * @author Juergen Knoedlseder
 */
%{
/* Put headers and other declarations here that are needed for compilation */
#include "GMath.hpp"
%}


/* __ Constants __________________________________________________________ */
namespace gammalib {
    const double pi           =  3.141592653589793238462643383279502884197;
    const double twopi        =  6.283185307179586476925286766559005768394;
    const double fourpi       = 12.56637061435917295385057353311801153679;
    const double pihalf       =  1.570796326794896619231321691639751442099;
    const double inv_pihalf   =  0.6366197723675813430755350534900574;
    const double inv_sqrt4pi  =  0.2820947917738781434740397257803862929220;
    const double inv_sqrt2pi  =  0.3989422804014327028632180827116826549172;
    const double pi2          = pi*pi;
    const double deg2rad      =  0.0174532925199432954743717;
    const double rad2deg      = 57.295779513082322864647722;
    const double ln2          =  0.6931471805599453094172321214581766;
    const double ln10         =  2.3025850929940456840179914546843642;
    const double inv_ln2      =  1.4426950408889634073599246810018921;
    const double inv_ln10     =  1.0/ln10;
    const double inv_loge     =  1.0/std::log10(std::exp(1.0));
    const double onethird     =  1.0/3.0;
    const double twothird     =  2.0/3.0;
    const double fourthird    =  4.0/3.0;
    const double sqrt_onehalf = std::sqrt(1.0/2.0);
    const double sqrt_two     = std::sqrt(2.0);
    const double sqrt_pihalf  = std::sqrt(pihalf);
    const double sqrt_twopi   = std::sqrt(twopi);
    const double sigma2fwhm   = 2.0 * std::sqrt(2.0 * ln2);
}

/* __ Prototypes _________________________________________________________ */
namespace gammalib {

    // Trigonometric functions
    double acos(const double& arg);
    double atan2(const double& y, const double& x);
    double cosd(const double& angle);
    double sind(const double& angle);
    double tand(const double& angle);
    double asind(const double& value);
    double acosd(const double& value);
    double atand(const double& value);
    double atan2d(const double& y, const double& x);
    void   sincosd(const double& angle, double *s, double *c);

    // Other functions
    double gammln(const double& arg);
    double erf(const double& arg);
    double erfc(const double& arg);
    double erfinv(const double& arg);
    double modulo(const double& v1, const double& v2);
    double plaw_integral(const double& x1,
                         const double& f1,
                         const double& x2,
                         const double& f2);
    double gauss_integral(const double& x1, const double& x2);
}
