/***************************************************************************
 *          GCTAModelRadialProfile.i - Radial Profile model class          *
 * ----------------------------------------------------------------------- *
 *  copyright (C) 2011-2018 by Juergen Knoedlseder                         *
 * ----------------------------------------------------------------------- *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 *                                                                         *
 ***************************************************************************/
/**
 * @file GCTAModelRadialProfile.i
 * @brief Radial Profile model class Python interface definition
 * @author Juergen Knoedlseder
 */
%{
/* Put headers and other declarations here that are needed for compilation */
#include "GCTAModelRadialProfile.hpp"
#include "GTools.hpp"
%}


/***********************************************************************//**
 * @class GCTAModelRadialProfile
 *
 * @brief Radial Profile CTA model class
 ***************************************************************************/
class GCTAModelRadialProfile : public GCTAModelRadial {
public:
    // Constructors and destructors
    GCTAModelRadialProfile(void);
    explicit GCTAModelRadialProfile(const double& width, const double& core,
                                    const double& tail);
    explicit GCTAModelRadialProfile(const GXmlElement& xml);
    GCTAModelRadialProfile(const GCTAModelRadialProfile& model);
    virtual ~GCTAModelRadialProfile(void);

    // Implemented pure virtual methods
    virtual void                    clear(void);
    virtual GCTAModelRadialProfile* clone(void) const;
    virtual std::string             classname(void) const;
    virtual std::string             type(void) const;
    virtual double                  eval(const double& offset,
                                         const bool& gradients = false) const;
    virtual GCTAInstDir             mc(GRan& ran) const;
    virtual double                  mc_max_value(const GCTAObservation& obs) const;
    virtual double                  omega(void) const;
    virtual void                    read(const GXmlElement& xml);
    virtual void                    write(GXmlElement& xml) const;

    // Other methods
    double width(void) const;
    double core(void) const;
    double tail(void) const;
    void   width(const double& width);
    void   core(const double& core);
    void   tail(const double& tail);
};


/***********************************************************************//**
 * @brief GCTAModelRadialProfile class extension
 ***************************************************************************/
%extend GCTAModelRadialProfile {
    GCTAModelRadialProfile copy() {
        return (*self);
    }
%pythoncode {
    def __getstate__(self):
        state = (self[0], self[1], self[2])
        return state
    def __setstate__(self, state):
        self.__init__()
        self[0] = state[0]
        self[1] = state[1]
        self[2] = state[2]
}
};
