/***************************************************************************
 *                      GCOMTools.i - COMPTEL tools                        *
 * ----------------------------------------------------------------------- *
 *  copyright (C) 2021-2025 by Juergen Knoedlseder                         *
 * ----------------------------------------------------------------------- *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 *                                                                         *
 ***************************************************************************/
/**
 * @file GCOMStatus.i
 * @brief Definition of COMPTEL tools
 * @author Juergen Knoedlseder
 */
%{
/* Put headers and other declarations here that are needed for compilation */
#include "GCOMTools.hpp"
%}

/* __ Constants __________________________________________________________ */

/* __ Prototypes _________________________________________________________ */
namespace gammalib {
    GTime  com_time(const int& tjd, const int& tics);
    int    com_tjd(const GTime& time);
    int    com_tics(const GTime& time);
    double com_tofcor(const GEnergy& emin,   const GEnergy& emax,
                      const int&     tofmin, const int&     tofmax);
}
