/***************************************************************************
 *                 GCOMLib.hpp - COMPTEL Support Header files              *
 * ----------------------------------------------------------------------- *
 *  copyright (C) 2012-2025 by Juergen Knoedlseder                         *
 * ----------------------------------------------------------------------- *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 *                                                                         *
 ***************************************************************************/
/**
 * @file GCOMLib.hpp
 * @brief Collection of COMPTEL support header files
 * @author Juergen Knoedlseder    
 */

#ifndef GCOMLIB_HPP
#define GCOMLIB_HPP

/* __ Includes ___________________________________________________________ */
#include "GammaLib.hpp"

/* __ COMPTEL specific headers ___________________________________________ */
#include "GCOMTools.hpp"
#include "GCOMEventCube.hpp"
#include "GCOMEventBin.hpp"
#include "GCOMInstDir.hpp"
#include "GCOMResponse.hpp"
#include "GCOMD1Response.hpp"
#include "GCOMD2Response.hpp"
#include "GCOMInstChars.hpp"
#include "GCOMObservation.hpp"
#include "GCOMSelection.hpp"
#include "GCOMStatus.hpp"
#include "GCOMDri.hpp"
#include "GCOMOads.hpp"
#include "GCOMOad.hpp"
#include "GCOMHkds.hpp"
#include "GCOMHkd.hpp"
#include "GCOMBvcs.hpp"
#include "GCOMBvc.hpp"
#include "GCOMTim.hpp"
#include "GCOMRoi.hpp"
#include "GCOMIaq.hpp"
#include "GCOMEventAtom.hpp"
#include "GCOMEventList.hpp"
#include "GCOMModelDRBPhibarBins.hpp"
#include "GCOMModelDRBPhibarNodes.hpp"
#include "GCOMModelDRM.hpp"

#endif /* GCOMLIB_HPP */
