/***************************************************************************
 *              GRegistry.cpp - Interface class for registries             *
 * ----------------------------------------------------------------------- *
 *  copyright (C) 2012-2021 by Juergen Knoedlseder                         *
 * ----------------------------------------------------------------------- *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 *                                                                         *
 ***************************************************************************/
/**
 * @file GRegistry.cpp
 * @brief Interface class implementation for registries
 * @author Juergen Knoedlseder
 */

/* __ Includes ___________________________________________________________ */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "GRegistry.hpp"
#include "GLog.hpp"

/* __ Method name definitions ____________________________________________ */

/* __ Macros _____________________________________________________________ */

/* __ Coding definitions _________________________________________________ */

/* __ Debug definitions __________________________________________________ */


/*==========================================================================
=                                                                         =
=                              Public methods                             =
=                                                                         =
==========================================================================*/

/***********************************************************************//**
 * @brief Return list of names in registry
 *
 * @return String containing list of names in registry
 ***************************************************************************/
std::string GRegistry::content(void) const
{
    // Initialise names
    std::string names;

    // Loop over all entries and append names
    for (int i = 0; i < size(); ++i) {
        if (i != 0) {
            names += ", ";
        }
        names += "\""+name(i)+"\"";
    }

    // Return names
    return names;
}


/*==========================================================================
 =                                                                         =
 =                                 Friends                                 =
 =                                                                         =
 ==========================================================================*/

/***********************************************************************//**
 * @brief Output operator
 *
 * @param[in] os Output stream.
 * @param[in] registry Registry.
 ***************************************************************************/
std::ostream& operator<<(std::ostream& os, const GRegistry& registry)
{
    // Write registry content in output stream
    os << registry.print();

    // Return output stream
    return os;
}


/***********************************************************************//**
 * @brief Log operator
 *
 * @param[in] log Logger.
 * @param[in] registry Registry.
 ***************************************************************************/
GLog& operator<<(GLog& log, const GRegistry& registry)
{
    // Write registry content into logger
    log << registry.print();

    // Return logger
    return log;
}
