/***************************************************************************
 *                GLATLib.hpp - Fermi/LAT Support Header files             *
 * ----------------------------------------------------------------------- *
 *  copyright (C) 2010-2021 by Juergen Knoedlseder                         *
 * ----------------------------------------------------------------------- *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 *                                                                         *
 ***************************************************************************/
/**
 * @file GLATLib.hpp
 * @brief Fermi/LAT headers
 * @author Juergen Knoedlseder
 */

#ifndef GLATLIB_HPP
#define GLATLIB_HPP

/* __ Includes ___________________________________________________________ */
#include "GammaLib.hpp"

/* __ Fermi/LAT specific headers _________________________________________ */
#include "GLATAeff.hpp"
#include "GLATEdisp.hpp"
#include "GLATEfficiency.hpp"
#include "GLATEventAtom.hpp"
#include "GLATEventBin.hpp"
#include "GLATEventCube.hpp"
#include "GLATEventList.hpp"
#include "GLATInstDir.hpp"
#include "GLATLtCube.hpp"
#include "GLATLtCubeMap.hpp"
#include "GLATMeanPsf.hpp"
#include "GLATObservation.hpp"
#include "GLATPsf.hpp"
#include "GLATPsfBase.hpp"
#include "GLATPsfV1.hpp"
#include "GLATPsfV3.hpp"
#include "GLATResponse.hpp"
#include "GLATResponseTable.hpp"
#include "GLATRoi.hpp"

#endif /* GLATLIB_HPP */
